<?php
$localConfig = [];
if (file_exists(__DIR__ . '/widget_config.php')) {
    $localConfig = require __DIR__ . '/widget_config.php';
}

$mode = $localConfig['mode'] ?? 'central';
$marker = $localConfig['marker'] ?? 'backlink_widget_active:yes';
$cacheMinutes = (int)($localConfig['cache_minutes'] ?? 15);
$code = $_GET['code'] ?? '';
$domainParam = $_GET['domain'] ?? '';
$code = $code !== '' ? $code : ($localConfig['code'] ?? '');
$domainParam = $domainParam !== '' ? $domainParam : ($localConfig['domain'] ?? '');

if ($code === '') {
    http_response_code(400);
    echo '<!-- missing code -->';
    exit;
}

function current_full_url(): string
{
    $isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (isset($_SERVER['SERVER_PORT']) && (int)$_SERVER['SERVER_PORT'] === 443);
    $scheme = $isHttps ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? '';
    $uri = $_SERVER['REQUEST_URI'] ?? '/';
    return $scheme . '://' . $host . $uri;
}

function widget_cache_path(string $code): string
{
    $dir = __DIR__ . '/cache';
    if (!is_dir($dir)) {
        @mkdir($dir, 0755, true);
    }
    return $dir . '/widget_' . preg_replace('/[^a-zA-Z0-9_-]/', '', $code) . '.json';
}

function output_links(array $links, string $marker): void
{
    echo '<div class="partner-links">';
    echo '<strong>Recommended Partners</strong>';
    echo '<ul>';
    foreach ($links as $link) {
        $keyword = htmlspecialchars($link['keyword'], ENT_QUOTES, 'UTF-8');
        $url = htmlspecialchars($link['target_url'], ENT_QUOTES, 'UTF-8');
        echo '<li><a href="' . $url . '">' . $keyword . '</a></li>';
    }
    echo '</ul>';
    echo '</div>';
    echo '<!-- ' . $marker . ' -->';
}

function random_user_agent(): string
{
    $agents = [
        'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0 Safari/537.36',
        'Mozilla/5.0 (Macintosh; Intel Mac OS X 13_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0 Safari/537.36',
        'Mozilla/5.0 (X11; Linux x86_64) Gecko/20100101 Firefox/126.0',
    ];
    return $agents[array_rand($agents)];
}

if ($mode === 'remote') {
    $server = rtrim($localConfig['server'] ?? '', '/');
    if ($server === '') {
        echo '<!-- widget server not configured -->';
        exit;
    }

    $domain = $domainParam !== '' ? $domainParam : current_full_url();
    $domain = filter_var($domain, FILTER_VALIDATE_URL) ? $domain : '';
    $cacheFile = widget_cache_path($code);
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < ($cacheMinutes * 60)) {
        $payload = json_decode((string)file_get_contents($cacheFile), true);
        if (!empty($payload['links'])) {
            output_links($payload['links'], $marker);
            exit;
        }
    }

    $payload = [
        'code' => $code,
        'domain' => $domain,
        'action' => 'fetch',
    ];
    $endpoint = $server . '/api/widget.php';

    $usePost = random_int(0, 1) === 1;
    $ch = curl_init();
    if ($usePost) {
        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));
    } else {
        curl_setopt($ch, CURLOPT_URL, $endpoint . '?' . http_build_query($payload));
    }
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, random_user_agent());
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode((string)$response, true);
    if (!empty($data['links'])) {
        file_put_contents($cacheFile, json_encode($data));
        output_links($data['links'], $marker);
    } else {
        echo '<!-- no links available -->';
        echo '<!-- ' . $marker . ' -->';
    }
    exit;
}

require __DIR__ . '/includes/bootstrap.php';

$domain = $domainParam !== '' ? $domainParam : current_full_url();
$domain = filter_var($domain, FILTER_VALIDATE_URL) ? $domain : '';
$cacheFile = widget_cache_path($code);
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < ($cacheMinutes * 60)) {
    $payload = json_decode((string)file_get_contents($cacheFile), true);
    if (!empty($payload['links'])) {
        output_links($payload['links'], $marker);
        exit;
    }
}

$pdo = db();
$stmt = $pdo->prepare('SELECT * FROM user_sites WHERE unique_code = ?');
$stmt->execute([$code]);
$site = $stmt->fetch();
$user = null;

if (!$site) {
    $stmt = $pdo->prepare('SELECT * FROM users WHERE widget_code = ?');
    $stmt->execute([$code]);
    $user = $stmt->fetch();
    if ($user && $domain !== '') {
        $stmt = $pdo->prepare('SELECT COUNT(*) FROM user_sites WHERE user_id = ?');
        $stmt->execute([$user['id']]);
        $count = (int)$stmt->fetchColumn();
        $stmt = $pdo->prepare('SELECT max_active_sites FROM plans WHERE id = ?');
        $stmt->execute([$user['plan_id']]);
        $limit = (int)$stmt->fetchColumn();
        if ($limit === 0 || $count < $limit) {
            $uniqueCode = random_token(8);
            $stmt = $pdo->prepare('INSERT INTO user_sites (user_id, domain_url, unique_code, registered_at, status) VALUES (?, ?, ?, NOW(), "inactive")');
            $stmt->execute([$user['id'], $domain, $uniqueCode]);
            $site = [
                'user_id' => $user['id'],
                'domain_url' => $domain,
                'unique_code' => $uniqueCode,
            ];
        }
    }
}

if (!$site) {
    echo '<!-- invalid code -->';
    echo '<!-- ' . $marker . ' -->';
    exit;
}

if (!$user) {
    $stmt = $pdo->prepare('SELECT * FROM users WHERE id = ?');
    $stmt->execute([$site['user_id']]);
    $user = $stmt->fetch();
}

$stmt = $pdo->prepare('SELECT * FROM plans WHERE id = ?');
$stmt->execute([$user['plan_id']]);
$plan = $stmt->fetch();
$limit = (int)($plan['max_links_per_site'] ?? 5);

$stmt = $pdo->prepare('SELECT keyword, target_url FROM backlinks WHERE user_id = ? AND status = "active" ORDER BY RAND() LIMIT ?');
$stmt->bindValue(1, $user['id'], PDO::PARAM_INT);
$stmt->bindValue(2, max(1, $limit), PDO::PARAM_INT);
$stmt->execute();
$links = $stmt->fetchAll();

file_put_contents($cacheFile, json_encode(['links' => $links]));
output_links($links, $marker);
