<?php
require __DIR__ . '/../includes/bootstrap.php';
require_login();
$user = current_user();
$pdo = db();

if (is_post()) {
    if (!csrf_verify()) {
        flash_set('error', 'Invalid session token.');
        redirect('/public/sites.php');
    }

    $domainUrl = trim($_POST['domain_url'] ?? '');
    if (!validate_url($domainUrl)) {
        flash_set('error', 'Please enter a valid URL (including https://).');
    } else {
        $stmt = $pdo->prepare('SELECT COUNT(*) FROM user_sites WHERE user_id = ?');
        $stmt->execute([$user['id']]);
        $count = (int)$stmt->fetchColumn();
        $stmt = $pdo->prepare('SELECT max_active_sites FROM plans WHERE id = ?');
        $stmt->execute([$user['plan_id']]);
        $limit = (int)$stmt->fetchColumn();
        if ($limit > 0 && $count >= $limit) {
            flash_set('error', 'Plan limit reached. Upgrade to add more sites.');
        } else {
            $uniqueCode = random_token(8);
            $stmt = $pdo->prepare('INSERT INTO user_sites (user_id, domain_url, unique_code, registered_at, status) VALUES (?, ?, ?, NOW(), "inactive")');
            $stmt->execute([$user['id'], $domainUrl, $uniqueCode]);
            log_action((int)$user['id'], 'site_add', $domainUrl);
            flash_set('success', 'Site added. Place the widget to activate.');
        }
    }
    redirect('/public/sites.php');
}

$stmt = $pdo->prepare('SELECT * FROM user_sites WHERE user_id = ? ORDER BY registered_at DESC');
$stmt->execute([$user['id']]);
$sites = $stmt->fetchAll();

$pageTitle = 'Sites - XBacklink';
require __DIR__ . '/../includes/header.php';
?>
<div class="row g-4">
    <div class="col-lg-5">
        <div class="card p-4">
            <div class="mb-3">
                <span class="badge badge-neon">Your widget code</span>
                <div class="mt-2"><code><?php echo e($user['widget_code']); ?></code></div>
                <small class="text-muted">Use this code in the widget to auto-register new sites.</small>
            </div>
            <h4>Register a site</h4>
            <form method="post">
                <?php echo csrf_input(); ?>
                <div class="mb-3">
                    <label class="form-label">Site URL where widget is placed</label>
                    <input class="form-control" name="domain_url" placeholder="https://example.com/partners" required>
                </div>
                <button class="btn btn-neon w-100" type="submit">Add site</button>
            </form>
            <small class="text-muted mt-3 d-block">After adding, embed the widget and wait for verification.</small>
        </div>
    </div>
    <div class="col-lg-7">
        <div class="card p-4">
            <h4>My sites</h4>
            <div class="table-responsive">
                <table class="table table-dark table-striped align-middle">
                    <thead>
                        <tr>
                            <th>URL</th>
                            <th>Status</th>
                            <th>Widget Code</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($sites as $site): ?>
                            <tr>
                                <td><?php echo e($site['domain_url']); ?></td>
                                <td><span class="badge badge-neon"><?php echo e($site['status']); ?></span></td>
                                <td>
                                    <code>&lt;?php include('<?php echo e(base_url()); ?>/widget.php?code=<?php echo e($user['widget_code']); ?>&amp;domain=<?php echo e(urlencode($site['domain_url'])); ?>'); ?&gt;</code>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="widget-box mt-3">
                <strong>Widget marker:</strong> <code><?php echo e($config['widget']['marker']); ?></code>
            </div>
        </div>
    </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
