<?php
require __DIR__ . '/../includes/bootstrap.php';
$pageTitle = 'Reset Password - XBacklink';

$token = $_GET['token'] ?? '';

if (is_post()) {
    if (!csrf_verify()) {
        flash_set('error', 'Invalid session token.');
        redirect('/public/reset.php');
    }

    if ($token !== '') {
        $password = $_POST['password'] ?? '';
        if (strlen($password) < 8) {
            flash_set('error', 'Password must be at least 8 characters.');
        } else {
            $pdo = db();
            $stmt = $pdo->prepare('SELECT user_id FROM password_resets WHERE token = ? AND expires_at > NOW()');
            $stmt->execute([$token]);
            $userId = $stmt->fetchColumn();
            if ($userId) {
                $stmt = $pdo->prepare('UPDATE users SET password_hash = ? WHERE id = ?');
                $stmt->execute([password_hash($password, PASSWORD_DEFAULT), $userId]);
                $pdo->prepare('DELETE FROM password_resets WHERE user_id = ?')->execute([$userId]);
                flash_set('success', 'Password updated. Please log in.');
                redirect('/public/login.php');
            } else {
                flash_set('error', 'Reset link expired.');
            }
        }
    } else {
        $email = trim($_POST['email'] ?? '');
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            flash_set('error', 'Enter a valid email.');
        } else {
            $pdo = db();
            $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ?');
            $stmt->execute([$email]);
            $userId = $stmt->fetchColumn();
            if ($userId) {
                $resetToken = random_token(16);
                $pdo->prepare('INSERT INTO password_resets (user_id, token, expires_at) VALUES (?, ?, DATE_ADD(NOW(), INTERVAL 1 HOUR))')->execute([$userId, $resetToken]);
                $resetUrl = base_url() . '/public/reset.php?token=' . $resetToken;
                $body = '<p>Reset your password: <a href="' . e($resetUrl) . '">Reset Password</a></p>';
                send_email($email, 'Password reset', $body);
            }
            flash_set('success', 'If that email exists, a reset link was sent.');
            redirect('/public/login.php');
        }
    }
}

require __DIR__ . '/../includes/header.php';
?>
<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card p-4">
            <h3 class="mb-3">Reset password</h3>
            <form method="post">
                <?php echo csrf_input(); ?>
                <?php if ($token !== ''): ?>
                    <div class="mb-3">
                        <label class="form-label">New Password</label>
                        <input class="form-control" type="password" name="password" minlength="8" required>
                    </div>
                    <button class="btn btn-neon w-100" type="submit">Update password</button>
                <?php else: ?>
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input class="form-control" type="email" name="email" required>
                    </div>
                    <button class="btn btn-neon w-100" type="submit">Send reset link</button>
                <?php endif; ?>
            </form>
        </div>
    </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
