<?php
require __DIR__ . '/../includes/bootstrap.php';
$pageTitle = 'Register - XBacklink';

if (is_post()) {
    if (!csrf_verify()) {
        flash_set('error', 'Invalid session token.');
        redirect('/public/register.php');
    }

    $username = trim($_POST['username'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($username === '' || $email === '' || $password === '') {
        flash_set('error', 'All fields are required.');
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        flash_set('error', 'Invalid email address.');
    } else {
        $pdo = db();
        $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ? OR username = ?');
        $stmt->execute([$email, $username]);
        if ($stmt->fetch()) {
            flash_set('error', 'Account already exists.');
        } else {
            $token = random_token(16);
            $planId = (int)(setting('default_plan_id', '1'));
            $widgetCode = random_token(8);
            $stmt = $pdo->prepare('INSERT INTO users (username, email, password_hash, role, plan_id, subscription_end, is_verified, verification_token, widget_code, created_at) VALUES (?, ?, ?, "user", ?, DATE_ADD(NOW(), INTERVAL 7 DAY), 0, ?, ?, NOW())');
            $stmt->execute([
                $username,
                $email,
                password_hash($password, PASSWORD_DEFAULT),
                $planId,
                $token,
                $widgetCode,
            ]);
            $verifyUrl = base_url() . '/public/verify.php?token=' . $token;
            $body = '<p>Welcome to XBacklink!</p><p>Verify your email: <a href="' . e($verifyUrl) . '">Verify Account</a></p>';
            send_email($email, 'Verify your account', $body);
            flash_set('success', 'Account created. Please check your email to verify.');
            log_action((int)$pdo->lastInsertId(), 'register', 'New user registration');
            redirect('/public/login.php');
        }
    }
}

require __DIR__ . '/../includes/header.php';
?>
<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card p-4">
            <h3 class="mb-3">Create account</h3>
            <form method="post">
                <?php echo csrf_input(); ?>
                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <input class="form-control" name="username" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Email</label>
                    <input class="form-control" type="email" name="email" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input class="form-control" type="password" name="password" minlength="8" required>
                </div>
                <button class="btn btn-neon w-100" type="submit">Register</button>
            </form>
            <small class="text-muted mt-3 d-block">By registering you agree to white-hat SEO only.</small>
        </div>
    </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
