<?php
require __DIR__ . '/../includes/bootstrap.php';
$user = current_user();
$pdo = db();

if ($user && is_post()) {
    if (!csrf_verify()) {
        flash_set('error', 'Invalid session token.');
        redirect('/public/plans.php');
    }
    $planId = (int)($_POST['plan_id'] ?? 0);
    $stmt = $pdo->prepare('SELECT id FROM plans WHERE id = ?');
    $stmt->execute([$planId]);
    $plan = $stmt->fetch();
    if ($plan) {
        $invoice = oxapay_create_invoice($user, $plan);
        if (!$invoice['ok']) {
            flash_set('error', $invoice['error'] ?? 'Payment gateway error.');
            redirect('/public/plans.php');
        }
        $data = $invoice['data'];
        $paymentUrl = $data['payment_url'] ?? '';
        $trackId = $data['track_id'] ?? null;
        $stmt = $pdo->prepare('INSERT INTO payments (user_id, plan_id, amount, currency, track_id, payment_url, order_id, status, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, \"pending\", NOW(), NOW())');
        $stmt->execute([
            $user['id'],
            $plan['id'],
            $plan['price_monthly'],
            'USD',
            $trackId,
            $paymentUrl,
            $invoice['order_id'] ?? null,
        ]);
        log_action((int)$user['id'], 'plan_invoice_created', (string)$planId);
        if ($paymentUrl !== '') {
            redirect($paymentUrl);
        }
        flash_set('error', 'Payment URL missing. Contact support.');
        redirect('/public/plans.php');
    }
}

$plans = $pdo->query('SELECT * FROM plans ORDER BY price_monthly ASC')->fetchAll();

$pageTitle = 'Plans - XBacklink';
require __DIR__ . '/../includes/header.php';
?>
<div class="row g-4">
    <?php foreach ($plans as $plan): ?>
        <div class="col-md-4" data-reveal>
            <div class="card p-4 h-100">
                <h4><?php echo e($plan['name']); ?></h4>
                <p class="display-6">$<?php echo e(number_format((float)$plan['price_monthly'], 2)); ?>/mo</p>
                <ul class="text-muted">
                    <li><?php echo e($plan['max_active_sites']); ?> active sites</li>
                    <li><?php echo e($plan['max_links_per_site']); ?> backlinks per site</li>
                </ul>
                <?php if ($user): ?>
                    <form method="post">
                        <?php echo csrf_input(); ?>
                        <input type="hidden" name="plan_id" value="<?php echo (int)$plan['id']; ?>">
                        <button class="btn btn-neon w-100" type="submit">Choose plan</button>
                    </form>
                <?php else: ?>
                    <a class="btn btn-neon w-100" href="/public/register.php">Get started</a>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>
<section class="mt-4">
    <div class="card p-4">
        <h5>Payment gateway</h5>
        <p class="text-muted mb-0">Stripe/PayPal integration is stubbed. Connect your gateway before charging customers.</p>
    </div>
</section>
<?php require __DIR__ . '/../includes/footer.php'; ?>
