<?php
require __DIR__ . '/../includes/bootstrap.php';

$raw = file_get_contents('php://input');
$payload = [];
if ($raw) {
    $decoded = json_decode($raw, true);
    if (is_array($decoded)) {
        $payload = $decoded;
    }
}
if (!empty($_POST)) {
    $payload = array_merge($payload, $_POST);
}

$trackId = $payload['track_id'] ?? ($payload['data']['track_id'] ?? null);
$status = oxapay_extract_status($payload);

if (!$trackId) {
    http_response_code(400);
    echo 'missing track_id';
    exit;
}

$pdo = db();
$stmt = $pdo->prepare('SELECT * FROM payments WHERE track_id = ?');
$stmt->execute([$trackId]);
$payment = $stmt->fetch();

if (!$payment) {
    http_response_code(404);
    echo 'payment not found';
    exit;
}

$pdo->prepare('UPDATE payments SET callback_payload = ?, updated_at = NOW() WHERE id = ?')
    ->execute([json_encode($payload), $payment['id']]);

$paidStatuses = ['paid', 'confirm', 'confirmed', 'completed', 'success'];
if ($status && in_array($status, $paidStatuses, true) && $payment['status'] !== 'paid') {
    $pdo->beginTransaction();
    try {
        $pdo->prepare('UPDATE payments SET status = "paid", updated_at = NOW() WHERE id = ?')->execute([$payment['id']]);
        $pdo->prepare('UPDATE users SET plan_id = ?, subscription_end = DATE_ADD(NOW(), INTERVAL 1 MONTH) WHERE id = ?')
            ->execute([$payment['plan_id'], $payment['user_id']]);
        log_action((int)$payment['user_id'], 'payment_paid', $trackId);
        $pdo->commit();
    } catch (Throwable $e) {
        $pdo->rollBack();
        http_response_code(500);
        echo 'error';
        exit;
    }
}

echo 'ok';
