<?php
require __DIR__ . '/../includes/bootstrap.php';
$pageTitle = 'Login - XBacklink';

if (is_post()) {
    if (!csrf_verify()) {
        flash_set('error', 'Invalid session token.');
        redirect('/public/login.php');
    }

    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($username === '' || $password === '') {
        flash_set('error', 'Username and password required.');
    } elseif (login_rate_limited($username)) {
        flash_set('error', 'Too many attempts. Try again later.');
    } else {
        $pdo = db();
        $stmt = $pdo->prepare('SELECT id, password_hash, is_verified, is_active FROM users WHERE username = ? OR email = ?');
        $stmt->execute([$username, $username]);
        $user = $stmt->fetch();
        if ($user && password_verify($password, $user['password_hash'])) {
            if ((int)$user['is_active'] !== 1) {
                flash_set('error', 'Account inactive. Contact support.');
            } elseif ((int)$user['is_verified'] !== 1) {
                flash_set('error', 'Please verify your email first.');
            } else {
                login_user((int)$user['id']);
                clear_login_attempts($username);
                log_action((int)$user['id'], 'login', 'User login');
                redirect('/public/dashboard.php');
            }
        } else {
            record_login_attempt($username);
            flash_set('error', 'Invalid credentials.');
        }
    }
}

require __DIR__ . '/../includes/header.php';
?>
<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card p-4">
            <h3 class="mb-3">Welcome back</h3>
            <form method="post">
                <?php echo csrf_input(); ?>
                <div class="mb-3">
                    <label class="form-label">Username or Email</label>
                    <input class="form-control" name="username" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input class="form-control" type="password" name="password" required>
                </div>
                <button class="btn btn-neon w-100" type="submit">Login</button>
            </form>
            <div class="d-flex justify-content-between mt-3">
                <a class="link-muted" href="/public/reset.php">Forgot password?</a>
                <a class="link-muted" href="/public/register.php">Create account</a>
            </div>
        </div>
    </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
