<?php
require __DIR__ . '/../includes/bootstrap.php';
$pageTitle = 'XBacklink - White-hat Partner Links';
require __DIR__ . '/../includes/header.php';
?>
<section class="hero" data-reveal>
    <div class="row align-items-center">
        <div class="col-lg-7">
            <h1>Partner-ready <span class="accent">backlinks</span> that prioritize trust.</h1>
            <p class="lead text-muted">A subscription-based backlink panel designed for transparent, user-visible link placements. No cloaking, no link schemes, just real partnerships.</p>
            <div class="d-flex gap-3">
                <a class="btn btn-neon" href="/public/register.php">Start Free</a>
                <a class="btn btn-outline-light" href="/public/plans.php">View Plans</a>
            </div>
        </div>
        <div class="col-lg-5 mt-4 mt-lg-0">
            <div class="card p-4">
                <h5 class="card-title">Compliance-first widget</h5>
                <p class="text-muted">Partners embed a single widget that surfaces curated, relevant links. Visible to users and crawlers equally, with clear attribution.</p>
                <div class="progress">
                    <div class="progress-bar" style="width: 92%"></div>
                </div>
                <small class="text-muted">92% average retention on active sites</small>
            </div>
        </div>
    </div>
</section>
<section class="py-4" data-reveal>
    <div class="row g-4">
        <div class="col-md-4">
            <div class="card p-4 h-100">
                <h5 class="card-title">Ethical placements</h5>
                <p class="text-muted">Links are placed manually on relevant sites, labeled as partners or recommendations.</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card p-4 h-100">
                <h5 class="card-title">Smart distribution</h5>
                <p class="text-muted">Balanced rotation ensures fair visibility across your active backlinks.</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card p-4 h-100">
                <h5 class="card-title">Verification built-in</h5>
                <p class="text-muted">Hourly checks confirm widgets remain visible, keeping your plan compliant.</p>
            </div>
        </div>
    </div>
</section>
<section class="py-4" data-reveal>
    <div class="card p-4">
        <h4>White-hat SEO only</h4>
        <p class="text-muted mb-0">By using this service you agree to place widgets on relevant websites and provide real value to visitors. Automated link exchanges, cloaking, and hidden links are prohibited.</p>
    </div>
</section>
<?php require __DIR__ . '/../includes/footer.php'; ?>
