<?php
require __DIR__ . '/../includes/bootstrap.php';
require_login();
$user = current_user();

$pdo = db();
$stmt = $pdo->prepare('SELECT * FROM plans WHERE id = ?');
$stmt->execute([$user['plan_id']]);
$plan = $stmt->fetch();

$stmt = $pdo->prepare('SELECT COUNT(*) FROM backlinks WHERE user_id = ? AND status = "active"');
$stmt->execute([$user['id']]);
$activeLinks = (int)$stmt->fetchColumn();

$stmt = $pdo->prepare('SELECT COUNT(*) FROM user_sites WHERE user_id = ? AND status = "active"');
$stmt->execute([$user['id']]);
$activeSites = (int)$stmt->fetchColumn();

$pageTitle = 'Dashboard - XBacklink';
require __DIR__ . '/../includes/header.php';
?>
<div class="row g-4" data-reveal>
    <div class="col-lg-4">
        <div class="card p-4 h-100">
            <h5 class="card-title">Current Plan</h5>
            <p class="display-6 mb-0"><?php echo e($plan['name'] ?? 'None'); ?></p>
            <small class="text-muted">Renews on <?php echo e($user['subscription_end'] ?? ''); ?></small>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="card p-4 h-100">
            <h5 class="card-title">Active Links</h5>
            <p class="display-6 mb-0"><?php echo $activeLinks; ?></p>
            <div class="progress mt-2">
                <div class="progress-bar" style="width: <?php echo $plan ? min(100, ($activeLinks / max(1, (int)$plan['max_links_per_site'])) * 100) : 0; ?>%"></div>
            </div>
            <small class="text-muted">Limit per site: <?php echo e($plan['max_links_per_site'] ?? '0'); ?></small>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="card p-4 h-100">
            <h5 class="card-title">Active Sites</h5>
            <p class="display-6 mb-0"><?php echo $activeSites; ?></p>
            <small class="text-muted">Max: <?php echo e($plan['max_active_sites'] ?? '0'); ?></small>
        </div>
    </div>
</div>
<section class="mt-4">
    <div class="card p-4">
        <h5>White-hat compliance notice</h5>
        <p class="text-muted mb-0">Place widgets only on relevant sites with real visibility. Automated exchanges, hidden links, or cloaking will result in suspension.</p>
    </div>
</section>
<?php require __DIR__ . '/../includes/footer.php'; ?>
