<?php
// XBacklink Installer
// Schema overview:
// users(id, username, email, password_hash, role, plan_id, subscription_end, widget_code, is_verified, is_active, verification_token, created_at)
// plans(id, name, price_monthly, max_active_sites, max_links_per_site, created_at)
// user_sites(id, user_id, domain_url, unique_code, registered_at, last_checked, status)
// backlinks(id, user_id, keyword, target_url, status, created_at)
// settings(key, value)
// logs(id, user_id, action, details, ip_address, created_at)
// login_attempts(id, username, ip_address, attempted_at)
// password_resets(id, user_id, token, expires_at)
// payments(id, user_id, plan_id, amount, currency, track_id, payment_url, order_id, status, callback_payload, created_at, updated_at)

if (file_exists(__DIR__ . '/includes/config.php')) {
    echo 'Already installed.';
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $dbHost = trim($_POST['db_host'] ?? '');
    $dbName = trim($_POST['db_name'] ?? '');
    $dbUser = trim($_POST['db_user'] ?? '');
    $dbPass = $_POST['db_pass'] ?? '';
    $baseUrl = trim($_POST['base_url'] ?? '');
    $adminUser = trim($_POST['admin_user'] ?? '');
    $adminEmail = trim($_POST['admin_email'] ?? '');
    $adminPass = $_POST['admin_pass'] ?? '';

    try {
        $pdo = new PDO('mysql:host=' . $dbHost . ';charset=utf8mb4', $dbUser, $dbPass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        ]);
        $pdo->exec('CREATE DATABASE IF NOT EXISTS `' . str_replace('`', '', $dbName) . '` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
        $pdo->exec('USE `' . str_replace('`', '', $dbName) . '`');

        $pdo->exec('CREATE TABLE IF NOT EXISTS users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(50) UNIQUE NOT NULL,
            email VARCHAR(120) UNIQUE NOT NULL,
            password_hash VARCHAR(255) NOT NULL,
            role ENUM("user","admin") NOT NULL DEFAULT "user",
            plan_id INT DEFAULT NULL,
            subscription_end DATETIME DEFAULT NULL,
            widget_code VARCHAR(32) UNIQUE DEFAULT NULL,
            is_verified TINYINT(1) NOT NULL DEFAULT 0,
            is_active TINYINT(1) NOT NULL DEFAULT 1,
            verification_token VARCHAR(64) DEFAULT NULL,
            created_at DATETIME NOT NULL
        ) ENGINE=InnoDB');

        $pdo->exec('CREATE TABLE IF NOT EXISTS plans (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(50) NOT NULL,
            price_monthly DECIMAL(10,2) NOT NULL DEFAULT 0,
            max_active_sites INT NOT NULL DEFAULT 1,
            max_links_per_site INT NOT NULL DEFAULT 5,
            created_at DATETIME NOT NULL
        ) ENGINE=InnoDB');

        $pdo->exec('CREATE TABLE IF NOT EXISTS user_sites (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            domain_url VARCHAR(255) NOT NULL,
            unique_code VARCHAR(32) UNIQUE NOT NULL,
            registered_at DATETIME NOT NULL,
            last_checked DATETIME DEFAULT NULL,
            status ENUM("active","inactive") NOT NULL DEFAULT "inactive",
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        ) ENGINE=InnoDB');

        $pdo->exec('CREATE TABLE IF NOT EXISTS backlinks (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            keyword VARCHAR(120) NOT NULL,
            target_url VARCHAR(255) NOT NULL,
            status ENUM("active","inactive") NOT NULL DEFAULT "active",
            created_at DATETIME NOT NULL,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        ) ENGINE=InnoDB');

        $pdo->exec('CREATE TABLE IF NOT EXISTS settings (
            `key` VARCHAR(100) PRIMARY KEY,
            value TEXT NOT NULL
        ) ENGINE=InnoDB');

        $pdo->exec('CREATE TABLE IF NOT EXISTS logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NULL,
            action VARCHAR(100) NOT NULL,
            details TEXT NOT NULL,
            ip_address VARCHAR(45) DEFAULT NULL,
            created_at DATETIME NOT NULL
        ) ENGINE=InnoDB');

        $pdo->exec('CREATE TABLE IF NOT EXISTS login_attempts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(120) NOT NULL,
            ip_address VARCHAR(45) DEFAULT NULL,
            attempted_at DATETIME NOT NULL
        ) ENGINE=InnoDB');

        $pdo->exec('CREATE TABLE IF NOT EXISTS password_resets (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            token VARCHAR(64) NOT NULL,
            expires_at DATETIME NOT NULL,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        ) ENGINE=InnoDB');

        $pdo->exec('CREATE TABLE IF NOT EXISTS payments (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            plan_id INT NOT NULL,
            amount DECIMAL(10,2) NOT NULL,
            currency VARCHAR(10) NOT NULL DEFAULT \"USD\",
            track_id VARCHAR(64) DEFAULT NULL,
            payment_url VARCHAR(255) DEFAULT NULL,
            order_id VARCHAR(64) DEFAULT NULL,
            status VARCHAR(30) NOT NULL DEFAULT \"pending\",
            callback_payload TEXT DEFAULT NULL,
            created_at DATETIME NOT NULL,
            updated_at DATETIME NOT NULL,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        ) ENGINE=InnoDB');

        $pdo->prepare('INSERT INTO plans (name, price_monthly, max_active_sites, max_links_per_site, created_at) VALUES ("Starter", 19.00, 3, 5, NOW())')->execute();
        $pdo->prepare('INSERT INTO plans (name, price_monthly, max_active_sites, max_links_per_site, created_at) VALUES ("Growth", 49.00, 10, 12, NOW())')->execute();
        $pdo->prepare('INSERT INTO plans (name, price_monthly, max_active_sites, max_links_per_site, created_at) VALUES ("Agency", 99.00, 30, 25, NOW())')->execute();

        $adminToken = bin2hex(random_bytes(16));
        $widgetCode = bin2hex(random_bytes(4));
        $stmt = $pdo->prepare('INSERT INTO users (username, email, password_hash, role, plan_id, subscription_end, widget_code, is_verified, is_active, verification_token, created_at) VALUES (?, ?, ?, "admin", 1, DATE_ADD(NOW(), INTERVAL 1 YEAR), ?, 1, 1, ?, NOW())');
        $stmt->execute([
            $adminUser,
            $adminEmail,
            password_hash($adminPass, PASSWORD_DEFAULT),
            $widgetCode,
            $adminToken,
        ]);

        $settings = [
            'site_name' => 'XBacklink',
            'admin_email' => $adminEmail,
            'default_plan_id' => '1',
            'oxapay_merchant_key' => 'HVY4J9-48EJMI-B2RMD1-6ZAHV2',
            'oxapay_sandbox' => '0',
        ];
        foreach ($settings as $key => $value) {
            $stmt = $pdo->prepare('INSERT INTO settings (`key`, value) VALUES (?, ?)');
            $stmt->execute([$key, $value]);
        }

        $config = [
            'db' => [
                'host' => $dbHost,
                'name' => $dbName,
                'user' => $dbUser,
                'pass' => $dbPass,
                'charset' => 'utf8mb4',
            ],
            'app' => [
                'base_url' => $baseUrl,
                'site_name' => 'XBacklink',
                'admin_email' => $adminEmail,
                'force_https' => true,
                'timezone' => 'UTC',
            ],
            'mail' => [
                'from_email' => 'no-reply@yourdomain.com',
                'from_name' => 'XBacklink',
                'driver' => 'mail',
                'smtp_host' => '',
                'smtp_user' => '',
                'smtp_pass' => '',
                'smtp_port' => 587,
                'smtp_secure' => 'tls',
            ],
            'security' => [
                'session_name' => 'xbacklink_session',
                'csrf_key' => bin2hex(random_bytes(16)),
                'login_attempt_window_minutes' => 15,
                'login_attempt_max' => 5,
            ],
            'widget' => [
                'marker' => 'backlink_widget_active:yes',
                'cache_minutes' => 15,
            ],
            'oxapay' => [
                'merchant_key' => 'HVY4J9-48EJMI-B2RMD1-6ZAHV2',
                'sandbox' => false,
            ],
        ];

        $configContent = "<?php\nreturn " . var_export($config, true) . ";\n";
        file_put_contents(__DIR__ . '/includes/config.php', $configContent);

        echo 'Installed successfully. Delete installer.php for security.';
        exit;
    } catch (Throwable $e) {
        $error = 'Install failed: ' . $e->getMessage();
    }
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Install XBacklink</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-white">
<div class="container py-5">
    <h1 class="mb-4">XBacklink Installer</h1>
    <?php if ($error): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <form method="post" class="row g-3">
        <div class="col-md-6">
            <label class="form-label">DB Host</label>
            <input class="form-control" name="db_host" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">DB Name</label>
            <input class="form-control" name="db_name" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">DB User</label>
            <input class="form-control" name="db_user" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">DB Password</label>
            <input class="form-control" type="password" name="db_pass">
        </div>
        <div class="col-12">
            <label class="form-label">Base URL</label>
            <input class="form-control" name="base_url" placeholder="https://yourdomain.com" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">Admin Username</label>
            <input class="form-control" name="admin_user" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">Admin Email</label>
            <input class="form-control" type="email" name="admin_email" required>
        </div>
        <div class="col-12">
            <label class="form-label">Admin Password</label>
            <input class="form-control" type="password" name="admin_pass" required>
        </div>
        <div class="col-12">
            <button class="btn btn-success" type="submit">Install</button>
        </div>
    </form>
</div>
</body>
</html>
