<?php
if (session_status() === PHP_SESSION_NONE) {
    $isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (isset($_SERVER['SERVER_PORT']) && (int)$_SERVER['SERVER_PORT'] === 443);
    $cookieParams = session_get_cookie_params();
    session_name($config['security']['session_name'] ?? 'xbacklink_session');
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => $cookieParams['path'] ?? '/',
        'domain' => $cookieParams['domain'] ?? '',
        'secure' => ($config['app']['force_https'] ?? false) ? true : $isHttps,
        'httponly' => true,
        'samesite' => 'Lax',
    ]);
    session_start();
}
