<?php
function oxapay_create_invoice(array $user, array $plan): array
{
    $amount = (float)$plan['price_monthly'];
    if ($amount <= 0) {
        return ['ok' => false, 'error' => 'Plan amount invalid.'];
    }

    $config = require __DIR__ . '/config.php';
    $merchantKey = setting('oxapay_merchant_key', $config['oxapay']['merchant_key'] ?? '');
    if ($merchantKey === '') {
        return ['ok' => false, 'error' => 'OxaPay merchant key not configured.'];
    }

    $sandboxSetting = setting('oxapay_sandbox', null);
    if ($sandboxSetting === null) {
        $sandbox = (bool)($config['oxapay']['sandbox'] ?? false);
    } else {
        $sandbox = $sandboxSetting === '1';
    }
    $baseUrl = base_url();

    $orderId = 'PLAN-' . $user['id'] . '-' . time();
    $payload = [
        'amount' => $amount,
        'currency' => 'USD',
        'lifetime' => 60,
        'fee_paid_by_payer' => 1,
        'mixed_payment' => true,
        'callback_url' => $baseUrl . '/public/oxapay_callback.php',
        'return_url' => $baseUrl . '/public/payment_return.php',
        'email' => $user['email'] ?? null,
        'order_id' => $orderId,
        'description' => 'Plan upgrade: ' . ($plan['name'] ?? 'plan'),
        'sandbox' => $sandbox,
    ];

    $ch = curl_init('https://api.oxapay.com/v1/payment/invoice');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'merchant_api_key: ' . $merchantKey,
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($response === false) {
        return ['ok' => false, 'error' => $error ?: 'OxaPay request failed.'];
    }

    $data = json_decode($response, true);
    if (!is_array($data) || (int)($data['status'] ?? 0) !== 200) {
        $message = $data['message'] ?? 'OxaPay error.';
        return ['ok' => false, 'error' => $message, 'raw' => $data];
    }

    return ['ok' => true, 'data' => $data['data'] ?? [], 'order_id' => $orderId, 'raw' => $data];
}

function oxapay_extract_status(array $payload): ?string
{
    $status = $payload['status'] ?? ($payload['data']['status'] ?? null);
    if (!is_string($status)) {
        return null;
    }
    return strtolower($status);
}
