<?php
require_once __DIR__ . '/config.php';

function send_email(string $to, string $subject, string $htmlBody): bool
{
    $config = require __DIR__ . '/config.php';
    $mail = $config['mail'] ?? [];

    if (class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
        $mailer = new PHPMailer\PHPMailer\PHPMailer(true);
        try {
            if (($mail['driver'] ?? 'mail') === 'smtp') {
                $mailer->isSMTP();
                $mailer->Host = $mail['smtp_host'] ?? '';
                $mailer->SMTPAuth = true;
                $mailer->Username = $mail['smtp_user'] ?? '';
                $mailer->Password = $mail['smtp_pass'] ?? '';
                $mailer->SMTPSecure = $mail['smtp_secure'] ?? 'tls';
                $mailer->Port = (int)($mail['smtp_port'] ?? 587);
            }
            $mailer->setFrom($mail['from_email'] ?? 'no-reply@example.com', $mail['from_name'] ?? 'XBacklink');
            $mailer->addAddress($to);
            $mailer->isHTML(true);
            $mailer->Subject = $subject;
            $mailer->Body = $htmlBody;
            $mailer->send();
            return true;
        } catch (Throwable $e) {
            return false;
        }
    }

    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8\r\n";
    $headers .= 'From: ' . ($mail['from_name'] ?? 'XBacklink') . ' <' . ($mail['from_email'] ?? 'no-reply@example.com') . ">\r\n";

    return mail($to, $subject, $htmlBody, $headers);
}
