<?php
force_https_if_needed();
$user = current_user();
$siteName = setting('site_name', $config['app']['site_name'] ?? 'XBacklink');
$pageTitle = $pageTitle ?? $siteName;
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($pageTitle); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <link href="/public/assets/css/style.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container">
        <a class="navbar-brand" href="/public/index.php"><?php echo e($siteName); ?></a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="nav">
            <ul class="navbar-nav ms-auto">
                <?php if ($user): ?>
                    <li class="nav-item"><a class="nav-link" href="/public/dashboard.php"><?php echo e(t('nav.dashboard')); ?></a></li>
                    <li class="nav-item"><a class="nav-link" href="/public/backlinks.php"><?php echo e(t('nav.backlinks')); ?></a></li>
                    <li class="nav-item"><a class="nav-link" href="/public/sites.php"><?php echo e(t('nav.sites')); ?></a></li>
                    <li class="nav-item"><a class="nav-link" href="/public/plans.php"><?php echo e(t('nav.plans')); ?></a></li>
                    <?php if ($user['role'] === 'admin'): ?>
                        <li class="nav-item"><a class="nav-link" href="/admin/index.php"><?php echo e(t('nav.admin')); ?></a></li>
                    <?php endif; ?>
                    <li class="nav-item"><a class="nav-link" href="/public/logout.php"><?php echo e(t('nav.logout')); ?></a></li>
                <?php else: ?>
                    <li class="nav-item"><a class="nav-link" href="/public/login.php">Login</a></li>
                    <li class="nav-item"><a class="nav-link" href="/public/register.php">Register</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>
<main class="container py-4">
<?php if ($message = flash_get('success')): ?>
    <div class="alert alert-success" role="alert"><?php echo e($message); ?></div>
<?php endif; ?>
<?php if ($message = flash_get('error')): ?>
    <div class="alert alert-danger" role="alert"><?php echo e($message); ?></div>
<?php endif; ?>
