<?php
require __DIR__ . '/includes/bootstrap.php';

function run_verification(): array
{
    $pdo = db();
    $marker = $GLOBALS['config']['widget']['marker'] ?? 'backlink_widget_active:yes';
    $sites = $pdo->query('SELECT id, domain_url FROM user_sites')->fetchAll();
    $results = ['checked' => 0, 'active' => 0, 'inactive' => 0];

    foreach ($sites as $site) {
        $results['checked']++;
        $url = $site['domain_url'];
        $context = stream_context_create([
            'http' => [
                'timeout' => 10,
                'user_agent' => 'XBacklinkVerifier/1.0',
            ],
        ]);
        $html = @file_get_contents($url, false, $context);
        $isActive = $html !== false && strpos($html, $marker) !== false;
        $status = $isActive ? 'active' : 'inactive';
        $stmt = $pdo->prepare('UPDATE user_sites SET status = ?, last_checked = NOW() WHERE id = ?');
        $stmt->execute([$status, $site['id']]);
        if ($isActive) {
            $results['active']++;
        } else {
            $results['inactive']++;
        }
    }

    log_action(null, 'cron_verify', json_encode($results));
    return $results;
}

if (php_sapi_name() === 'cli' || basename(__FILE__) === basename($_SERVER['SCRIPT_FILENAME'] ?? '')) {
    $results = run_verification();
    echo 'Checked: ' . $results['checked'] . "\n";
    echo 'Active: ' . $results['active'] . "\n";
    echo 'Inactive: ' . $results['inactive'] . "\n";
}
