<?php
require __DIR__ . '/../includes/bootstrap.php';
header('Content-Type: application/json');

$code = $_POST['code'] ?? ($_GET['code'] ?? '');
$domain = $_POST['domain'] ?? ($_GET['domain'] ?? '');
$domain = filter_var($domain, FILTER_VALIDATE_URL) ? $domain : '';
$action = $_POST['action'] ?? ($_GET['action'] ?? 'fetch');

if ($code === '') {
    echo json_encode(['error' => 'missing_code']);
    exit;
}

$pdo = db();
$site = null;
$user = null;

$stmt = $pdo->prepare('SELECT * FROM user_sites WHERE unique_code = ?');
$stmt->execute([$code]);
$site = $stmt->fetch();

if (!$site) {
    $stmt = $pdo->prepare('SELECT * FROM users WHERE widget_code = ?');
    $stmt->execute([$code]);
    $user = $stmt->fetch();
    if ($user && $domain !== '') {
        $stmt = $pdo->prepare('SELECT COUNT(*) FROM user_sites WHERE user_id = ?');
        $stmt->execute([$user['id']]);
        $count = (int)$stmt->fetchColumn();
        $stmt = $pdo->prepare('SELECT max_active_sites FROM plans WHERE id = ?');
        $stmt->execute([$user['plan_id']]);
        $limit = (int)$stmt->fetchColumn();
        if ($limit === 0 || $count < $limit) {
            $uniqueCode = random_token(8);
            $stmt = $pdo->prepare('INSERT INTO user_sites (user_id, domain_url, unique_code, registered_at, status) VALUES (?, ?, ?, NOW(), "inactive")');
            $stmt->execute([$user['id'], $domain, $uniqueCode]);
            $site = [
                'user_id' => $user['id'],
                'domain_url' => $domain,
                'unique_code' => $uniqueCode,
            ];
        }
    }
}

if (!$site) {
    echo json_encode(['error' => 'invalid_code']);
    exit;
}

if (!$user) {
    $stmt = $pdo->prepare('SELECT * FROM users WHERE id = ?');
    $stmt->execute([$site['user_id']]);
    $user = $stmt->fetch();
}

if ($action === 'register') {
    if ($domain !== '') {
        $stmt = $pdo->prepare('UPDATE user_sites SET domain_url = ?, last_checked = NOW() WHERE unique_code = ?');
        $stmt->execute([$domain, $site['unique_code']]);
    }
    echo json_encode(['status' => 'registered', 'site_code' => $site['unique_code']]);
    exit;
}

$stmt = $pdo->prepare('SELECT * FROM plans WHERE id = ?');
$stmt->execute([$user['plan_id']]);
$plan = $stmt->fetch();
$limit = (int)($plan['max_links_per_site'] ?? 5);

$stmt = $pdo->prepare('SELECT keyword, target_url FROM backlinks WHERE user_id = ? AND status = "active" ORDER BY RAND() LIMIT ?');
$stmt->bindValue(1, $user['id'], PDO::PARAM_INT);
$stmt->bindValue(2, max(1, $limit), PDO::PARAM_INT);
$stmt->execute();
$links = $stmt->fetchAll();

echo json_encode([
    'links' => $links,
    'marker' => $config['widget']['marker'] ?? 'backlink_widget_active:yes',
]);
