<?php
require __DIR__ . '/../includes/bootstrap.php';
require_admin();
$pdo = db();

if (is_post()) {
    if (!csrf_verify()) {
        flash_set('error', 'Invalid session token.');
        redirect('/admin/users.php');
    }
    $action = $_POST['action'] ?? '';
    $userId = (int)($_POST['user_id'] ?? 0);
    if ($action === 'toggle_role') {
        $stmt = $pdo->prepare('UPDATE users SET role = IF(role = "admin", "user", "admin") WHERE id = ?');
        $stmt->execute([$userId]);
        log_action(null, 'admin_toggle_role', (string)$userId);
    } elseif ($action === 'deactivate') {
        $stmt = $pdo->prepare('UPDATE users SET is_active = 0 WHERE id = ?');
        $stmt->execute([$userId]);
        log_action(null, 'admin_deactivate_user', (string)$userId);
    }
    flash_set('success', 'User updated.');
    redirect('/admin/users.php');
}

$users = $pdo->query('SELECT id, username, email, role, plan_id, subscription_end, is_active FROM users ORDER BY created_at DESC')->fetchAll();

$pageTitle = 'Manage Users - XBacklink';
require __DIR__ . '/../includes/header.php';
?>
<div class="card p-4">
    <h4>Users</h4>
    <div class="table-responsive">
        <table class="table table-dark table-striped align-middle">
            <thead>
                <tr>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Role</th>
                    <th>Plan</th>
                    <th>Subscription End</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $u): ?>
                    <tr>
                        <td><?php echo e($u['username']); ?></td>
                        <td><?php echo e($u['email']); ?></td>
                        <td><?php echo e($u['role']); ?></td>
                        <td><?php echo e($u['plan_id']); ?></td>
                        <td><?php echo e($u['subscription_end']); ?></td>
                        <td><?php echo (int)$u['is_active'] === 1 ? 'active' : 'inactive'; ?></td>
                        <td class="text-end">
                            <form method="post" class="d-inline">
                                <?php echo csrf_input(); ?>
                                <input type="hidden" name="action" value="toggle_role">
                                <input type="hidden" name="user_id" value="<?php echo (int)$u['id']; ?>">
                                <button class="btn btn-sm btn-outline-light" type="submit">Toggle Role</button>
                            </form>
                            <form method="post" class="d-inline" onsubmit="return confirm('Deactivate user?');">
                                <?php echo csrf_input(); ?>
                                <input type="hidden" name="action" value="deactivate">
                                <input type="hidden" name="user_id" value="<?php echo (int)$u['id']; ?>">
                                <button class="btn btn-sm btn-outline-danger" type="submit">Deactivate</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
