<?php
require __DIR__ . '/../includes/bootstrap.php';
require_admin();
$pdo = db();

$sites = $pdo->query('SELECT user_sites.*, users.username FROM user_sites JOIN users ON users.id = user_sites.user_id ORDER BY registered_at DESC')->fetchAll();

$pageTitle = 'All Sites - XBacklink';
require __DIR__ . '/../includes/header.php';
?>
<div class="card p-4">
    <h4>Partner Sites</h4>
    <div class="table-responsive">
        <table class="table table-dark table-striped">
            <thead>
                <tr>
                    <th>User</th>
                    <th>URL</th>
                    <th>Status</th>
                    <th>Last Checked</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($sites as $site): ?>
                    <tr>
                        <td><?php echo e($site['username']); ?></td>
                        <td><?php echo e($site['domain_url']); ?></td>
                        <td><?php echo e($site['status']); ?></td>
                        <td><?php echo e($site['last_checked'] ?? ''); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
