<?php
require __DIR__ . '/../includes/bootstrap.php';
require_admin();
$pdo = db();

if (is_post()) {
    if (!csrf_verify()) {
        flash_set('error', 'Invalid session token.');
        redirect('/admin/settings.php');
    }

    $settings = [
        'site_name' => trim($_POST['site_name'] ?? ''),
        'admin_email' => trim($_POST['admin_email'] ?? ''),
        'default_plan_id' => trim($_POST['default_plan_id'] ?? '1'),
        'oxapay_merchant_key' => trim($_POST['oxapay_merchant_key'] ?? ''),
        'oxapay_sandbox' => isset($_POST['oxapay_sandbox']) ? '1' : '0',
    ];
    foreach ($settings as $key => $value) {
        $stmt = $pdo->prepare('INSERT INTO settings (`key`, value) VALUES (?, ?) ON DUPLICATE KEY UPDATE value = VALUES(value)');
        $stmt->execute([$key, $value]);
    }
    log_action(null, 'admin_settings_update', 'Settings updated');
    flash_set('success', 'Settings saved.');
    redirect('/admin/settings.php');
}

$current = $pdo->query('SELECT `key`, value FROM settings')->fetchAll();
$settings = [];
foreach ($current as $row) {
    $settings[$row['key']] = $row['value'];
}

$pageTitle = 'Settings - XBacklink';
require __DIR__ . '/../includes/header.php';
?>
<div class="card p-4">
    <h4>Platform Settings</h4>
    <form method="post">
        <?php echo csrf_input(); ?>
        <div class="mb-3">
            <label class="form-label">Site name</label>
            <input class="form-control" name="site_name" value="<?php echo e($settings['site_name'] ?? 'XBacklink'); ?>">
        </div>
        <div class="mb-3">
            <label class="form-label">Admin email</label>
            <input class="form-control" name="admin_email" value="<?php echo e($settings['admin_email'] ?? 'admin@example.com'); ?>">
        </div>
        <div class="mb-3">
            <label class="form-label">Default plan ID</label>
            <input class="form-control" name="default_plan_id" value="<?php echo e($settings['default_plan_id'] ?? '1'); ?>">
        </div>
        <div class="mb-3">
            <label class="form-label">OxaPay merchant key</label>
            <input class="form-control" name="oxapay_merchant_key" value="<?php echo e($settings['oxapay_merchant_key'] ?? ''); ?>">
        </div>
        <div class="form-check mb-3">
            <input class="form-check-input" type="checkbox" name="oxapay_sandbox" id="oxapay_sandbox" <?php echo (($settings['oxapay_sandbox'] ?? '0') === '1') ? 'checked' : ''; ?>>
            <label class="form-check-label" for="oxapay_sandbox">OxaPay sandbox mode</label>
        </div>
        <button class="btn btn-neon" type="submit">Save settings</button>
    </form>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
