<?php
require __DIR__ . '/../includes/bootstrap.php';
require_admin();
$pdo = db();

if (is_post()) {
    if (!csrf_verify()) {
        flash_set('error', 'Invalid session token.');
        redirect('/admin/plans.php');
    }

    $action = $_POST['action'] ?? '';
    if ($action === 'add') {
        $name = trim($_POST['name'] ?? '');
        $price = (float)($_POST['price_monthly'] ?? 0);
        $maxSites = (int)($_POST['max_active_sites'] ?? 0);
        $maxLinks = (int)($_POST['max_links_per_site'] ?? 0);
        $stmt = $pdo->prepare('INSERT INTO plans (name, price_monthly, max_active_sites, max_links_per_site, created_at) VALUES (?, ?, ?, ?, NOW())');
        $stmt->execute([$name, $price, $maxSites, $maxLinks]);
        log_action(null, 'admin_plan_add', $name);
        flash_set('success', 'Plan added.');
    } elseif ($action === 'delete') {
        $id = (int)($_POST['id'] ?? 0);
        $stmt = $pdo->prepare('DELETE FROM plans WHERE id = ?');
        $stmt->execute([$id]);
        log_action(null, 'admin_plan_delete', (string)$id);
        flash_set('success', 'Plan deleted.');
    }
    redirect('/admin/plans.php');
}

$plans = $pdo->query('SELECT * FROM plans ORDER BY price_monthly ASC')->fetchAll();

$pageTitle = 'Manage Plans - XBacklink';
require __DIR__ . '/../includes/header.php';
?>
<div class="row g-4">
    <div class="col-lg-4">
        <div class="card p-4">
            <h4>Add plan</h4>
            <form method="post">
                <?php echo csrf_input(); ?>
                <input type="hidden" name="action" value="add">
                <div class="mb-3">
                    <label class="form-label">Name</label>
                    <input class="form-control" name="name" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Price monthly</label>
                    <input class="form-control" type="number" step="0.01" name="price_monthly" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Max active sites</label>
                    <input class="form-control" type="number" name="max_active_sites" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Max links per site</label>
                    <input class="form-control" type="number" name="max_links_per_site" required>
                </div>
                <button class="btn btn-neon w-100" type="submit">Create plan</button>
            </form>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="card p-4">
            <h4>Existing plans</h4>
            <div class="table-responsive">
                <table class="table table-dark table-striped">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Price</th>
                            <th>Sites</th>
                            <th>Links/site</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($plans as $plan): ?>
                            <tr>
                                <td><?php echo e($plan['name']); ?></td>
                                <td>$<?php echo e(number_format((float)$plan['price_monthly'], 2)); ?></td>
                                <td><?php echo e($plan['max_active_sites']); ?></td>
                                <td><?php echo e($plan['max_links_per_site']); ?></td>
                                <td class="text-end">
                                    <form method="post" onsubmit="return confirm('Delete plan?');">
                                        <?php echo csrf_input(); ?>
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="id" value="<?php echo (int)$plan['id']; ?>">
                                        <button class="btn btn-sm btn-outline-danger" type="submit">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
