<?php
require __DIR__ . '/../includes/bootstrap.php';
require_admin();
$pdo = db();

$logs = $pdo->query('SELECT logs.*, users.username FROM logs LEFT JOIN users ON users.id = logs.user_id ORDER BY logs.created_at DESC LIMIT 200')->fetchAll();

$pageTitle = 'Logs - XBacklink';
require __DIR__ . '/../includes/header.php';
?>
<div class="card p-4">
    <h4>Latest activity</h4>
    <div class="table-responsive">
        <table class="table table-dark table-striped">
            <thead>
                <tr>
                    <th>Time</th>
                    <th>User</th>
                    <th>Action</th>
                    <th>Details</th>
                    <th>IP</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($logs as $log): ?>
                    <tr>
                        <td><?php echo e($log['created_at']); ?></td>
                        <td><?php echo e($log['username'] ?? 'system'); ?></td>
                        <td><?php echo e($log['action']); ?></td>
                        <td><?php echo e($log['details']); ?></td>
                        <td><?php echo e($log['ip_address']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
