<?php
require __DIR__ . '/../includes/bootstrap.php';
require_admin();
$pdo = db();

$stats = [
    'users' => (int)$pdo->query('SELECT COUNT(*) FROM users')->fetchColumn(),
    'active_sites' => (int)$pdo->query('SELECT COUNT(*) FROM user_sites WHERE status = "active"')->fetchColumn(),
    'backlinks' => (int)$pdo->query('SELECT COUNT(*) FROM backlinks')->fetchColumn(),
];

$pageTitle = 'Admin Dashboard - XBacklink';
require __DIR__ . '/../includes/header.php';
?>
<div class="card p-4 mb-4">
    <h3>Admin Control Center</h3>
    <p class="text-muted mb-0">Manage users, plans, and compliance activity.</p>
</div>
<div class="row g-4">
    <div class="col-md-4">
        <div class="card p-4">
            <h5>Total Users</h5>
            <p class="display-6 mb-0"><?php echo $stats['users']; ?></p>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card p-4">
            <h5>Active Sites</h5>
            <p class="display-6 mb-0"><?php echo $stats['active_sites']; ?></p>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card p-4">
            <h5>Total Backlinks</h5>
            <p class="display-6 mb-0"><?php echo $stats['backlinks']; ?></p>
        </div>
    </div>
</div>
<div class="card p-4 mt-4">
    <div class="d-flex gap-3 flex-wrap">
        <a class="btn btn-neon" href="/admin/users.php">Manage Users</a>
        <a class="btn btn-outline-light" href="/admin/plans.php">Manage Plans</a>
        <a class="btn btn-outline-light" href="/admin/sites.php">View Sites</a>
        <a class="btn btn-outline-light" href="/admin/logs.php">View Logs</a>
        <a class="btn btn-outline-light" href="/admin/settings.php">Settings</a>
        <a class="btn btn-outline-light" href="/admin/cron.php">Run Cron</a>
    </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
