# XBacklink

White-hat backlink management panel with a partner widget and verification cron.

## Setup

1. Point your web root to the project root so `/public` routes work, or adjust paths.
2. Browse to `installer.php` and follow the prompts.
3. Delete `installer.php` after install.
4. Configure mail in `includes/config.php` if needed.
5. Set OxaPay merchant key in Admin Settings or `includes/config.php`.

## Widget

Central hosting:

```
<?php include('https://yourdomain.com/widget.php?code=YOUR_WIDGET_CODE&domain=https://partner-site.com/partners'); ?>
```

Local hosting:

1. Copy `widget.php` and `widget_config.sample.php` to the partner site.
2. Rename `widget_config.sample.php` to `widget_config.php` and set `server`.
3. Include locally:

```
<?php include(__DIR__ . '/widget.php'); ?>
```

## Cron

Run hourly:

```
php cron.php
```

## Compliance

This system enforces visible partner links and prohibits cloaking or hidden placements.

## OxaPay

The plans page creates invoices through OxaPay (generate-invoice endpoint). Configure the merchant key and optionally enable sandbox mode in Admin Settings.

If upgrading an existing install, add the `payments` table from `installer.php` and create settings keys `oxapay_merchant_key` and `oxapay_sandbox` in the `settings` table.
